#include "point4.hpp"
#include "math.h" //for sqrt

Point::Point(LPARAM lParam)
{
	_x = LOWORD(lParam);
   _y = HIWORD(lParam);
}

BOOL Point::operator==(const Point &p) const
{
	return (_x==p._x && _y==p._y);
}

Point Point::operator=(const Point &pix)
{
	_x=pix._x;
	 _y=pix._y;
	 return *this;
}

Real Point::Magnitude()const
{
	return sqrt(Real(_x)*_x + Real(_y)*_y);
}

Point Point::operator+(const Point &p)const
{
	return Point(_x + p._x, _y + p._y);
}

Point& Point::operator+=(const Point &p)
{
	_x += p._x;
	_y += p._y;
	return *this;
}

Point Point::operator-(const Point &p)const
{
	return Point(_x - p._x, _y - p._y);
}

Point& Point::operator-=(const Point &p)
{
	_x -= p._x;
	_y -= p._y;
	return *this;
}

Point operator*(Real r, const Point &p)
{
	return Point(int(r*p._x), int(r*p._y));
}

Point& Point::operator*=(Real r)
{
	_x = int(_x*r);
	_y = int(_y*r);
	return *this;
}

